#!/sbin/busybox sh

BUSYBOX="/sbin/busybox"

### preinstall ###
PREINSTALL_PATH="/system/preinstall"
APP_TAGS_PATH="/data/misc/app_tags"
if [ ! -d $APP_TAGS_PATH ]; then
    mkdir -p $APP_TAGS_PATH
fi

for apk in `ls $PREINSTALL_PATH`; do
    apk_path=$PREINSTALL_PATH/$apk
    old_version=
    new_version=`aapt d badging $apk_path | busybox awk '$1=="package:" {print $3}' | busybox awk -F\' '{print $2}'`
    package_name=`aapt d badging $apk_path | busybox awk '$1=="package:" {print $2}' | busybox awk -F\' '{print $2}'`
    tag="$APP_TAGS_PATH/$package_name"
    if [ -f $tag ]; then
        old_version=`cat $tag`
    fi
    if [ "$old_version" == "" ]; then
        old_version=0
    fi
    if [ $old_version -lt $new_version ]; then
        $BUSYBOX nice -n 5 /system/bin/sh /system/bin/pm install -r $apk_path
        echo "$new_version" > $tag
    fi
done

### backup data ###
mkdir /bootloader
mount -t vfat /dev/block/by-name/bootloader /bootloader

if [ -e /bootloader/data.need.backup ] ; then
    echo "data backup:tar /databk/data_backup.tar /data"
    mkdir /databk
    mount -t ext4 /dev/block/by-name/databk /databk

    rm /databk/data_backup.tar

   $BUSYBOX tar -cf /databk/data_backup.tar /data
    rm /bootloader/data.need.backup
else
    echo "do nothing"
fi

umount /bootloader
rmdir /bootloader

### cp iptv list ###
if [ ! -f /sdcard/vodlist.m3u ]; then
    #echo "cp file vodlist.m3u" 
    cp /etc/vodlist.m3u /sdcard/
else
    NENMD5=$(busybox md5sum /etc/vodlist.m3u)
    NENMD5=${NENMD5%%"  /"*}                    
    OLDMD5=$(busybox md5sum /sdcard/vodlist.m3u)
    OLDMD5=${OLDMD5%%"  /"*}       
    #echo "$NENMD5, $OLDMD5"        
    if [ $NENMD5 != $OLDMD5 ]; then
       #echo "cp file vodlist.m3u"              
       cp /etc/vodlist.m3u /sdcard/
    fi
fi


